# Create a developer platform login account and register as a partner

[Developer Platform](https://partners.shoplazza.com/) provides web-based assistance to developers for creating, managing applications and earnings. It serves as an important agency window for Shoplazza's partner business.

> **Note:**
> Before you register as a partner, you need to have a Shoplazza account.

## Create Shoplazza Account

If you don't have a Shoplazza account, follow these steps:
1. Visit [Shoplazza Registration Page](https://partners.shoplazza.com/).
2. Click on "Sign Up" and fill in the required details.
3. Confirm your email address.

## Create a Partner Account

1. Log in with your Shoplazza Account, then you will see the page as the following

2. Click "Create a Partner Account."

3. Fill Out the Partner Form and provide the following details:

> **Note**
> Remember to check the box after reading the [Partner Program Agreement](https://www.shoplazza.com/pages/partner-program-agreement).

| Fields | Description |
|--------|-------------|
| Business name | The postal code of your business's location (e.g., 12345 in the U.S., M5V 3E7 in Canada). |
| Website | If your business has an active website, you can fill in the URL. |
| Primary Business Email | The primary contact information for your business or team. |
| Phone number | Your business or personal contact number (e.g., +1 234-567-890). |
| Address | The full address of your business. |
| City | The city where the business is located. |
| Zip/Postal Code | The zip code of the area where the business is located. |
| Province/State | The province/state where the business is located. |
| Country/Region | The country/region where the business is located. |

> **Note**
> Shoplazza may use the information provided as a partner byline for instances such as billing and email communication and could also offer a customized feature experience based on the same information.

## Login Partner Account

After logging in to the [Partner Center](https://partners.shoplazza.com/), select your partner account and click on the partner account name to access your partner account.

After login partner account:

## Understanding your Shoplazza Account and Partner Account

To help our partners understand the relationship between the Shoplazza and Partner Accounts, we provide the following explanation and image:

A **Shoplazza Account** acts as the administrator and owner, overseeing multiple Partner Accounts. Each Partner Account serves as an "Organization," for managing specific teams, such as an APP Development Team or an Affiliate Marketing Team. This setup ensures clear boundaries for each team.

In the diagram:
• The **Shoplazza Account (Owner)** is managing all Partner Accounts.
• **Partner Account A** is dedicated to the APP Development Team, with staff members working collaboratively within their own organization.
• **Partner Account B** supports the Affiliate Marketing Team, similarly providing a dedicated environment for its staff.

Once a Partner Account is created, you gain access to its functional control panel, where features and data relevant to that team or business unit are managed. If you operate several separate teams, you can create multiple Partner Accounts, each assigned to a specific team, ensuring streamlined operations and clear accountability.